
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});

	$('#js-user-form').validate({
		rules: {
			name: {
				required: true
			},
			email: {
				required: true,
				email: true,
			},
			password: {
				required: true,
				minlength: 9
			},
			password_edit: {
				minlength: 9
			},
			role: {
				required: true
			},
			profile_picture: {
				required: false,
				accept: 'image/jpeg, image/png, image/gif',
			}
		},
		messages: {
			email: {
				required: "Please enter a email address",
				email: "Please enter a valid email address"
			},
			name: "Please enter name",
			password: {
				required: 'Please enter a password',
				minlength: 'Password must be at least 9 characters long',
			},
			password_edit: {
				minlength: 'Password must be at least 9 characters long',
			},
			role: "Please select a user role",
			profile_image: {
				accept: 'Please select a valid image file (JPEG, PNG, GIF)',
			}
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});
